# Installation Instructions

## Step 1: Create Icon Files

The extension needs three PNG icon files. You can create them quickly:

**Option A: Use this online tool (easiest)**
1. Go to https://www.favicon-generator.org/
2. Upload any car image or use text "AT"
3. Generate and download
4. Rename the files to: `icon16.png`, `icon48.png`, `icon128.png`
5. Place them in the `chrome-extension` folder

**Option B: Use simple colored squares (quick temporary solution)**
You can use any image editor to create three blue (#3498db) squares:
- icon16.png (16x16 pixels)
- icon48.png (48x48 pixels)
- icon128.png (128x128 pixels)

The extension will work with any PNG files of these sizes.

## Step 2: Load Extension in Chrome

1. Open Chrome browser
2. Navigate to `chrome://extensions/`
3. Toggle "Developer mode" ON (top right corner)
4. Click "Load unpacked" button
5. Navigate to and select the `chrome-extension` folder
6. The AutoTrader Price Tracker extension should now appear!

## Step 3: Test It

1. Go to https://www.autotrader.co.uk/car-details/202511087745239
2. Click the extension icon in your Chrome toolbar
3. You should see the car price (£13,999) and details displayed

## Troubleshooting

- **"Manifest file is missing or unreadable"**: Make sure you selected the `chrome-extension` folder itself
- **Icons not showing**: Create the PNG files as described in Step 1
- **Extension not working**: Check Chrome DevTools console for errors
