# AutoTrader Price Tracker Chrome Extension

A Chrome extension to extract car prices and details from AutoTrader UK listings.

## Installation

1. Open Chrome and go to `chrome://extensions/`
2. Enable "Developer mode" (toggle in top right)
3. Click "Load unpacked"
4. Select the `chrome-extension` folder
5. The extension icon should appear in your toolbar

## Usage

1. Navigate to any AutoTrader UK car listing page
2. Click the extension icon
3. The extension will display:
   - Car price
   - Car title/name
   - Year
   - Mileage
   - Registration (if available)

## Creating Icons

Since the icons need to be PNG files, you can either:

### Option 1: Use any online icon generator
- Go to https://favicon.io/favicon-generator/
- Create a simple icon with a car emoji or "AT" text
- Download as PNG in 16x16, 48x48, and 128x128 sizes
- Rename to icon16.png, icon48.png, icon128.png

### Option 2: Use a simple colored square
Run this command to create basic colored icons:

```bash
# Requires ImageMagick
convert -size 16x16 xc:'#3498db' icon16.png
convert -size 48x48 xc:'#3498db' icon48.png  
convert -size 128x128 xc:'#3498db' icon128.png
```

## Features

- ✅ Extract price from AutoTrader listings
- ✅ Extract car details (year, mileage, title)
- ✅ Copy listing URL to clipboard
- 🔜 Save directly to Car Price Tracker database

## Files

- `manifest.json` - Extension configuration
- `popup.html` - Popup UI
- `popup.js` - Price extraction logic
- `icon*.png` - Extension icons (you need to create these)
